/*
 * Castaway
 *  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
 *
 * $File$ - 68k logical instructions
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 *
 * revision history
 *  23.05.2002  JH  FAST1.0.1 code import: KR -> ANSI, restructuring
 *  10.07.2002  JH  Minor clarification when CCR/SR is target (without effect)
 *  27.08.2002  JH  ... with effect! Fixed bug. Restructured & clarified.
 *  30.10.2002  JH  Replaced "% 8" with "& 7". Helps lesser compilers to generate faster code.
 */
#ifndef PROTOH
static char     sccsid[] = "$Id: op68klogop.c,v 1.5 2002/10/30 16:23:06 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

/*
 * Opfuncs.
 */
#define OlogSR(Code, Op, OpSR, Priv, DeclS, Get1, DeclT, Get2, Set2, GetSR, SetSR)\
void            Code(void)\
{\
    DeclS(source)\
    DeclT(target)\
    long address;\
    switch (inst & 7) {\
    case 0x0:\
        Get1(source, 0)\
        address = GetMPCW();\
        pc += 2;\
        Get2(address, target)\
        Op(target, source)\
        Set2(address, target)\
        break;\
    case 0x1:\
        Get1(source, 0)\
        address = GetMPCL();\
        pc += 4;\
        Get2(address, target)\
        Op(target, source)\
        Set2(address, target)\
        break;\
    case 0x4:\
        if (Priv && !GetS()) { ExceptionGroup1(PRIV); };\
        Get1(source, 0)\
        GetSR(address2, target)\
        OpSR(target, source)\
        SetSR(address2, target)\
        break;\
    default:\
        ExceptionGroup1(ILLINSTR);\
        break;\
    }\
}

#define DoAnd(target,source) target &= source; ClrCVSetNZ(target);
#define DoAndSR(target,source) target &= source;

#define DoEor(target,source) target ^= source; ClrCVSetNZ(target);
#define DoEorSR(target,source) target ^= source;

#define DoOr(target,source) target |= source; ClrCVSetNZ(target);
#define DoOrSR(target,source) target |= source;

#else

#define OlogSR(a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) \
    extern void a1(void);

#endif

Oper (Opc000, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc010, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc018, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc020, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc028, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc030, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc038, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Opc040, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc050, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc058, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc060, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc068, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc070, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc078, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Opc080, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc090, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc098, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc0a0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc0a8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc0b0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Opc0b8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)

Oper (Opc110, DoAnd, DB, SdB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opc118, DoAnd, DB, SdB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opc120, DoAnd, DB, SdB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opc128, DoAnd, DB, SdB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opc130, DoAnd, DB, SdB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opc138, DoAnd, DB, SdB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opc150, DoAnd, DW, SdW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opc158, DoAnd, DW, SdW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opc160, DoAnd, DW, SdW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opc168, DoAnd, DW, SdW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opc170, DoAnd, DW, SdW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opc178, DoAnd, DW, SdW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opc190, DoAnd, DL, SdL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opc198, DoAnd, DL, SdL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opc1a0, DoAnd, DL, SdL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opc1a8, DoAnd, DL, SdL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opc1b0, DoAnd, DL, SdL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opc1b8, DoAnd, DL, SdL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opc200, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc210, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc218, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc220, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc228, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc230, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc238, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Opc240, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc250, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc258, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc260, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc268, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc270, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc278, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Opc280, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc290, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc298, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc2a0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc2a8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc2b0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Opc2b8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)

Oper (Opc310, DoAnd, DB, SdB, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opc318, DoAnd, DB, SdB, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opc320, DoAnd, DB, SdB, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opc328, DoAnd, DB, SdB, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opc330, DoAnd, DB, SdB, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opc338, DoAnd, DB, SdB, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opc350, DoAnd, DW, SdW, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opc358, DoAnd, DW, SdW, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opc360, DoAnd, DW, SdW, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opc368, DoAnd, DW, SdW, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opc370, DoAnd, DW, SdW, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opc378, DoAnd, DW, SdW, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opc390, DoAnd, DL, SdL, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opc398, DoAnd, DL, SdL, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opc3a0, DoAnd, DL, SdL, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opc3a8, DoAnd, DL, SdL, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opc3b0, DoAnd, DL, SdL, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opc3b8, DoAnd, DL, SdL, 1, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opc400, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc410, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc418, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc420, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc428, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc430, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc438, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Opc440, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc450, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc458, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc460, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc468, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc470, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc478, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Opc480, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc490, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc498, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc4a0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc4a8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc4b0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Opc4b8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)

Oper (Opc510, DoAnd, DB, SdB, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opc518, DoAnd, DB, SdB, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opc520, DoAnd, DB, SdB, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opc528, DoAnd, DB, SdB, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opc530, DoAnd, DB, SdB, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opc538, DoAnd, DB, SdB, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opc550, DoAnd, DW, SdW, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opc558, DoAnd, DW, SdW, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opc560, DoAnd, DW, SdW, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opc568, DoAnd, DW, SdW, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opc570, DoAnd, DW, SdW, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opc578, DoAnd, DW, SdW, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opc590, DoAnd, DL, SdL, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opc598, DoAnd, DL, SdL, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opc5a0, DoAnd, DL, SdL, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opc5a8, DoAnd, DL, SdL, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opc5b0, DoAnd, DL, SdL, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opc5b8, DoAnd, DL, SdL, 2, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opc600, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc610, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc618, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc620, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc628, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc630, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc638, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Opc640, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc650, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc658, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc660, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc668, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc670, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc678, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Opc680, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc690, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc698, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc6a0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc6a8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc6b0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Opc6b8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)

Oper (Opc710, DoAnd, DB, SdB, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opc718, DoAnd, DB, SdB, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opc720, DoAnd, DB, SdB, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opc728, DoAnd, DB, SdB, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opc730, DoAnd, DB, SdB, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opc738, DoAnd, DB, SdB, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opc750, DoAnd, DW, SdW, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opc758, DoAnd, DW, SdW, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opc760, DoAnd, DW, SdW, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opc768, DoAnd, DW, SdW, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opc770, DoAnd, DW, SdW, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opc778, DoAnd, DW, SdW, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opc790, DoAnd, DL, SdL, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opc798, DoAnd, DL, SdL, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opc7a0, DoAnd, DL, SdL, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opc7a8, DoAnd, DL, SdL, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opc7b0, DoAnd, DL, SdL, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opc7b8, DoAnd, DL, SdL, 3, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opc800, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc810, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc818, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc820, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc828, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc830, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc838, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Opc840, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc850, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc858, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc860, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc868, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc870, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc878, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Opc880, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc890, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc898, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc8a0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc8a8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc8b0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Opc8b8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)

Oper (Opc910, DoAnd, DB, SdB, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opc918, DoAnd, DB, SdB, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opc920, DoAnd, DB, SdB, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opc928, DoAnd, DB, SdB, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opc930, DoAnd, DB, SdB, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opc938, DoAnd, DB, SdB, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opc950, DoAnd, DW, SdW, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opc958, DoAnd, DW, SdW, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opc960, DoAnd, DW, SdW, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opc968, DoAnd, DW, SdW, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opc970, DoAnd, DW, SdW, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opc978, DoAnd, DW, SdW, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opc990, DoAnd, DL, SdL, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opc998, DoAnd, DL, SdL, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opc9a0, DoAnd, DL, SdL, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opc9a8, DoAnd, DL, SdL, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opc9b0, DoAnd, DL, SdL, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opc9b8, DoAnd, DL, SdL, 4, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opca00, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca10, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca18, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca20, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca28, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca30, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca38, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Opca40, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca50, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca58, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca60, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca68, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca70, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca78, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Opca80, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opca90, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opca98, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opcaa0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opcaa8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opcab0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Opcab8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)

Oper (Opcb10, DoAnd, DB, SdB, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opcb18, DoAnd, DB, SdB, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opcb20, DoAnd, DB, SdB, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opcb28, DoAnd, DB, SdB, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opcb30, DoAnd, DB, SdB, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opcb38, DoAnd, DB, SdB, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opcb50, DoAnd, DW, SdW, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opcb58, DoAnd, DW, SdW, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opcb60, DoAnd, DW, SdW, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opcb68, DoAnd, DW, SdW, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opcb70, DoAnd, DW, SdW, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opcb78, DoAnd, DW, SdW, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opcb90, DoAnd, DL, SdL, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opcb98, DoAnd, DL, SdL, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opcba0, DoAnd, DL, SdL, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opcba8, DoAnd, DL, SdL, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opcbb0, DoAnd, DL, SdL, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opcbb8, DoAnd, DL, SdL, 5, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opcc00, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc10, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc18, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc20, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc28, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc30, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc38, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Opcc40, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc50, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc58, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc60, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc68, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc70, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc78, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Opcc80, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opcc90, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opcc98, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opcca0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opcca8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opccb0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Opccb8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)

Oper (Opcd10, DoAnd, DB, SdB, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opcd18, DoAnd, DB, SdB, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opcd20, DoAnd, DB, SdB, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opcd28, DoAnd, DB, SdB, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opcd30, DoAnd, DB, SdB, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opcd38, DoAnd, DB, SdB, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opcd50, DoAnd, DW, SdW, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opcd58, DoAnd, DW, SdW, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opcd60, DoAnd, DW, SdW, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opcd68, DoAnd, DW, SdW, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opcd70, DoAnd, DW, SdW, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opcd78, DoAnd, DW, SdW, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opcd90, DoAnd, DL, SdL, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opcd98, DoAnd, DL, SdL, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opcda0, DoAnd, DL, SdL, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opcda8, DoAnd, DL, SdL, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opcdb0, DoAnd, DL, SdL, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opcdb8, DoAnd, DL, SdL, 6, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opce00, DoAnd, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce10, DoAnd, DB, SainB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce18, DoAnd, DB, SaipB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce20, DoAnd, DB, SmaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce28, DoAnd, DB, SdaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce30, DoAnd, DB, SaixB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce38, DoAnd, DB, SearB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Opce40, DoAnd, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce50, DoAnd, DW, SainW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce58, DoAnd, DW, SaipW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce60, DoAnd, DW, SmaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce68, DoAnd, DW, SdaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce70, DoAnd, DW, SaixW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce78, DoAnd, DW, SearW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Opce80, DoAnd, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opce90, DoAnd, DL, SainL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opce98, DoAnd, DL, SaipL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opcea0, DoAnd, DL, SmaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opcea8, DoAnd, DL, SdaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opceb0, DoAnd, DL, SaixL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Opceb8, DoAnd, DL, SearL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)

Oper (Opcf10, DoAnd, DB, SdB, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opcf18, DoAnd, DB, SdB, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opcf20, DoAnd, DB, SdB, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opcf28, DoAnd, DB, SdB, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opcf30, DoAnd, DB, SdB, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opcf38, DoAnd, DB, SdB, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opcf50, DoAnd, DW, SdW, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opcf58, DoAnd, DW, SdW, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opcf60, DoAnd, DW, SdW, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opcf68, DoAnd, DW, SdW, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opcf70, DoAnd, DW, SdW, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opcf78, DoAnd, DW, SdW, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opcf90, DoAnd, DL, SdL, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opcf98, DoAnd, DL, SdL, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opcfa0, DoAnd, DL, SdL, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opcfa8, DoAnd, DL, SdL, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opcfb0, DoAnd, DL, SdL, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opcfb8, DoAnd, DL, SdL, 7, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8000, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8010, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8018, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8020, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8028, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8030, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8038, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op8040, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8050, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8058, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8060, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8068, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8070, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8078, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op8080, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op8090, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op8098, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op80a0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op80a8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op80b0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op80b8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)

Oper (Op8110, DoOr, DB, SdB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8118, DoOr, DB, SdB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8120, DoOr, DB, SdB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8128, DoOr, DB, SdB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8130, DoOr, DB, SdB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8138, DoOr, DB, SdB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8150, DoOr, DW, SdW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8158, DoOr, DW, SdW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8160, DoOr, DW, SdW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8168, DoOr, DW, SdW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8170, DoOr, DW, SdW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8178, DoOr, DW, SdW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8190, DoOr, DL, SdL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8198, DoOr, DL, SdL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op81a0, DoOr, DL, SdL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op81a8, DoOr, DL, SdL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op81b0, DoOr, DL, SdL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op81b8, DoOr, DL, SdL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8200, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8210, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8218, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8220, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8228, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8230, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8238, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op8240, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8250, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8258, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8260, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8268, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8270, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8278, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op8280, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op8290, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op8298, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op82a0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op82a8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op82b0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op82b8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)

Oper (Op8310, DoOr, DB, SdB, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8318, DoOr, DB, SdB, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8320, DoOr, DB, SdB, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8328, DoOr, DB, SdB, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8330, DoOr, DB, SdB, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8338, DoOr, DB, SdB, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8350, DoOr, DW, SdW, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8358, DoOr, DW, SdW, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8360, DoOr, DW, SdW, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8368, DoOr, DW, SdW, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8370, DoOr, DW, SdW, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8378, DoOr, DW, SdW, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8390, DoOr, DL, SdL, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8398, DoOr, DL, SdL, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op83a0, DoOr, DL, SdL, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op83a8, DoOr, DL, SdL, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op83b0, DoOr, DL, SdL, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op83b8, DoOr, DL, SdL, 1, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8400, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8410, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8418, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8420, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8428, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8430, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8438, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op8440, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8450, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8458, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8460, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8468, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8470, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8478, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op8480, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op8490, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op8498, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op84a0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op84a8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op84b0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op84b8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)

Oper (Op8510, DoOr, DB, SdB, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8518, DoOr, DB, SdB, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8520, DoOr, DB, SdB, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8528, DoOr, DB, SdB, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8530, DoOr, DB, SdB, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8538, DoOr, DB, SdB, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8550, DoOr, DW, SdW, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8558, DoOr, DW, SdW, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8560, DoOr, DW, SdW, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8568, DoOr, DW, SdW, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8570, DoOr, DW, SdW, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8578, DoOr, DW, SdW, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8590, DoOr, DL, SdL, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8598, DoOr, DL, SdL, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op85a0, DoOr, DL, SdL, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op85a8, DoOr, DL, SdL, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op85b0, DoOr, DL, SdL, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op85b8, DoOr, DL, SdL, 2, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8600, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8610, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8618, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8620, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8628, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8630, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8638, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op8640, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8650, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8658, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8660, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8668, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8670, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8678, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op8680, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op8690, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op8698, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op86a0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op86a8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op86b0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op86b8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)

Oper (Op8710, DoOr, DB, SdB, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8718, DoOr, DB, SdB, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8720, DoOr, DB, SdB, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8728, DoOr, DB, SdB, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8730, DoOr, DB, SdB, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8738, DoOr, DB, SdB, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8750, DoOr, DW, SdW, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8758, DoOr, DW, SdW, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8760, DoOr, DW, SdW, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8768, DoOr, DW, SdW, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8770, DoOr, DW, SdW, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8778, DoOr, DW, SdW, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8790, DoOr, DL, SdL, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8798, DoOr, DL, SdL, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op87a0, DoOr, DL, SdL, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op87a8, DoOr, DL, SdL, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op87b0, DoOr, DL, SdL, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op87b8, DoOr, DL, SdL, 3, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8800, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8810, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8818, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8820, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8828, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8830, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8838, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op8840, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8850, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8858, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8860, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8868, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8870, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8878, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op8880, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op8890, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op8898, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op88a0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op88a8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op88b0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op88b8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)

Oper (Op8910, DoOr, DB, SdB, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8918, DoOr, DB, SdB, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8920, DoOr, DB, SdB, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8928, DoOr, DB, SdB, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8930, DoOr, DB, SdB, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8938, DoOr, DB, SdB, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8950, DoOr, DW, SdW, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8958, DoOr, DW, SdW, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8960, DoOr, DW, SdW, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8968, DoOr, DW, SdW, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8970, DoOr, DW, SdW, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8978, DoOr, DW, SdW, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8990, DoOr, DL, SdL, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8998, DoOr, DL, SdL, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op89a0, DoOr, DL, SdL, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op89a8, DoOr, DL, SdL, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op89b0, DoOr, DL, SdL, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op89b8, DoOr, DL, SdL, 4, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8a00, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a10, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a18, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a20, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a28, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a30, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a38, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op8a40, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a50, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a58, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a60, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a68, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a70, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a78, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op8a80, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8a90, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8a98, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8aa0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8aa8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8ab0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op8ab8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)

Oper (Op8b10, DoOr, DB, SdB, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8b18, DoOr, DB, SdB, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8b20, DoOr, DB, SdB, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8b28, DoOr, DB, SdB, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8b30, DoOr, DB, SdB, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8b38, DoOr, DB, SdB, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8b50, DoOr, DW, SdW, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8b58, DoOr, DW, SdW, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8b60, DoOr, DW, SdW, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8b68, DoOr, DW, SdW, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8b70, DoOr, DW, SdW, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8b78, DoOr, DW, SdW, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8b90, DoOr, DL, SdL, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8b98, DoOr, DL, SdL, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op8ba0, DoOr, DL, SdL, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op8ba8, DoOr, DL, SdL, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op8bb0, DoOr, DL, SdL, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op8bb8, DoOr, DL, SdL, 5, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8c00, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c10, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c18, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c20, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c28, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c30, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c38, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op8c40, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c50, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c58, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c60, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c68, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c70, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c78, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op8c80, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8c90, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8c98, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8ca0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8ca8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8cb0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op8cb8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)

Oper (Op8d10, DoOr, DB, SdB, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8d18, DoOr, DB, SdB, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8d20, DoOr, DB, SdB, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8d28, DoOr, DB, SdB, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8d30, DoOr, DB, SdB, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8d38, DoOr, DB, SdB, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8d50, DoOr, DW, SdW, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8d58, DoOr, DW, SdW, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8d60, DoOr, DW, SdW, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8d68, DoOr, DW, SdW, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8d70, DoOr, DW, SdW, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8d78, DoOr, DW, SdW, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8d90, DoOr, DL, SdL, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8d98, DoOr, DL, SdL, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op8da0, DoOr, DL, SdL, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op8da8, DoOr, DL, SdL, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op8db0, DoOr, DL, SdL, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op8db8, DoOr, DL, SdL, 6, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op8e00, DoOr, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e10, DoOr, DB, SainB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e18, DoOr, DB, SaipB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e20, DoOr, DB, SmaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e28, DoOr, DB, SdaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e30, DoOr, DB, SaixB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e38, DoOr, DB, SearB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op8e40, DoOr, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e50, DoOr, DW, SainW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e58, DoOr, DW, SaipW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e60, DoOr, DW, SmaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e68, DoOr, DW, SdaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e70, DoOr, DW, SaixW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e78, DoOr, DW, SearW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op8e80, DoOr, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8e90, DoOr, DL, SainL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8e98, DoOr, DL, SaipL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8ea0, DoOr, DL, SmaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8ea8, DoOr, DL, SdaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8eb0, DoOr, DL, SaixL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op8eb8, DoOr, DL, SearL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)

Oper (Op8f10, DoOr, DB, SdB, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op8f18, DoOr, DB, SdB, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op8f20, DoOr, DB, SdB, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op8f28, DoOr, DB, SdB, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op8f30, DoOr, DB, SdB, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op8f38, DoOr, DB, SdB, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op8f50, DoOr, DW, SdW, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op8f58, DoOr, DW, SdW, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op8f60, DoOr, DW, SdW, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op8f68, DoOr, DW, SdW, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op8f70, DoOr, DW, SdW, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op8f78, DoOr, DW, SdW, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op8f90, DoOr, DL, SdL, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op8f98, DoOr, DL, SdL, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op8fa0, DoOr, DL, SdL, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op8fa8, DoOr, DL, SdL, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op8fb0, DoOr, DL, SdL, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op8fb8, DoOr, DL, SdL, 7, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opb100, DoEor, DB, SdB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opb110, DoEor, DB, SdB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opb118, DoEor, DB, SdB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opb120, DoEor, DB, SdB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opb128, DoEor, DB, SdB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opb130, DoEor, DB, SdB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opb138, DoEor, DB, SdB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opb140, DoEor, DW, SdW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opb150, DoEor, DW, SdW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opb158, DoEor, DW, SdW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opb160, DoEor, DW, SdW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opb168, DoEor, DW, SdW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opb170, DoEor, DW, SdW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opb178, DoEor, DW, SdW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opb180, DoEor, DL, SdL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opb190, DoEor, DL, SdL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opb198, DoEor, DL, SdL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opb1a0, DoEor, DL, SdL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opb1a8, DoEor, DL, SdL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opb1b0, DoEor, DL, SdL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opb1b8, DoEor, DL, SdL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opb300, DoEor, DB, SdB, 1, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opb310, DoEor, DB, SdB, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opb318, DoEor, DB, SdB, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opb320, DoEor, DB, SdB, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opb328, DoEor, DB, SdB, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opb330, DoEor, DB, SdB, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opb338, DoEor, DB, SdB, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opb340, DoEor, DW, SdW, 1, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opb350, DoEor, DW, SdW, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opb358, DoEor, DW, SdW, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opb360, DoEor, DW, SdW, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opb368, DoEor, DW, SdW, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opb370, DoEor, DW, SdW, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opb378, DoEor, DW, SdW, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opb380, DoEor, DL, SdL, 1, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opb390, DoEor, DL, SdL, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opb398, DoEor, DL, SdL, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opb3a0, DoEor, DL, SdL, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opb3a8, DoEor, DL, SdL, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opb3b0, DoEor, DL, SdL, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opb3b8, DoEor, DL, SdL, 1, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opb500, DoEor, DB, SdB, 2, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opb510, DoEor, DB, SdB, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opb518, DoEor, DB, SdB, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opb520, DoEor, DB, SdB, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opb528, DoEor, DB, SdB, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opb530, DoEor, DB, SdB, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opb538, DoEor, DB, SdB, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opb540, DoEor, DW, SdW, 2, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opb550, DoEor, DW, SdW, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opb558, DoEor, DW, SdW, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opb560, DoEor, DW, SdW, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opb568, DoEor, DW, SdW, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opb570, DoEor, DW, SdW, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opb578, DoEor, DW, SdW, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opb580, DoEor, DL, SdL, 2, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opb590, DoEor, DL, SdL, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opb598, DoEor, DL, SdL, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opb5a0, DoEor, DL, SdL, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opb5a8, DoEor, DL, SdL, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opb5b0, DoEor, DL, SdL, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opb5b8, DoEor, DL, SdL, 2, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opb700, DoEor, DB, SdB, 3, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opb710, DoEor, DB, SdB, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opb718, DoEor, DB, SdB, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opb720, DoEor, DB, SdB, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opb728, DoEor, DB, SdB, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opb730, DoEor, DB, SdB, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opb738, DoEor, DB, SdB, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opb740, DoEor, DW, SdW, 3, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opb750, DoEor, DW, SdW, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opb758, DoEor, DW, SdW, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opb760, DoEor, DW, SdW, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opb768, DoEor, DW, SdW, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opb770, DoEor, DW, SdW, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opb778, DoEor, DW, SdW, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opb780, DoEor, DL, SdL, 3, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opb790, DoEor, DL, SdL, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opb798, DoEor, DL, SdL, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opb7a0, DoEor, DL, SdL, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opb7a8, DoEor, DL, SdL, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opb7b0, DoEor, DL, SdL, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opb7b8, DoEor, DL, SdL, 3, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opb900, DoEor, DB, SdB, 4, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opb910, DoEor, DB, SdB, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opb918, DoEor, DB, SdB, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opb920, DoEor, DB, SdB, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opb928, DoEor, DB, SdB, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opb930, DoEor, DB, SdB, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opb938, DoEor, DB, SdB, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opb940, DoEor, DW, SdW, 4, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opb950, DoEor, DW, SdW, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opb958, DoEor, DW, SdW, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opb960, DoEor, DW, SdW, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opb968, DoEor, DW, SdW, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opb970, DoEor, DW, SdW, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opb978, DoEor, DW, SdW, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opb980, DoEor, DL, SdL, 4, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opb990, DoEor, DL, SdL, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opb998, DoEor, DL, SdL, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opb9a0, DoEor, DL, SdL, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opb9a8, DoEor, DL, SdL, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opb9b0, DoEor, DL, SdL, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opb9b8, DoEor, DL, SdL, 4, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opbb00, DoEor, DB, SdB, 5, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opbb10, DoEor, DB, SdB, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opbb18, DoEor, DB, SdB, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opbb20, DoEor, DB, SdB, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opbb28, DoEor, DB, SdB, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opbb30, DoEor, DB, SdB, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opbb38, DoEor, DB, SdB, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opbb40, DoEor, DW, SdW, 5, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opbb50, DoEor, DW, SdW, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opbb58, DoEor, DW, SdW, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opbb60, DoEor, DW, SdW, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opbb68, DoEor, DW, SdW, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opbb70, DoEor, DW, SdW, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opbb78, DoEor, DW, SdW, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opbb80, DoEor, DL, SdL, 5, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opbb90, DoEor, DL, SdL, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opbb98, DoEor, DL, SdL, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opbba0, DoEor, DL, SdL, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opbba8, DoEor, DL, SdL, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opbbb0, DoEor, DL, SdL, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opbbb8, DoEor, DL, SdL, 5, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opbd00, DoEor, DB, SdB, 6, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opbd10, DoEor, DB, SdB, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opbd18, DoEor, DB, SdB, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opbd20, DoEor, DB, SdB, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opbd28, DoEor, DB, SdB, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opbd30, DoEor, DB, SdB, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opbd38, DoEor, DB, SdB, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opbd40, DoEor, DW, SdW, 6, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opbd50, DoEor, DW, SdW, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opbd58, DoEor, DW, SdW, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opbd60, DoEor, DW, SdW, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opbd68, DoEor, DW, SdW, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opbd70, DoEor, DW, SdW, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opbd78, DoEor, DW, SdW, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opbd80, DoEor, DL, SdL, 6, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opbd90, DoEor, DL, SdL, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opbd98, DoEor, DL, SdL, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opbda0, DoEor, DL, SdL, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opbda8, DoEor, DL, SdL, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opbdb0, DoEor, DL, SdL, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opbdb8, DoEor, DL, SdL, 6, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Opbf00, DoEor, DB, SdB, 7, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Opbf10, DoEor, DB, SdB, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Opbf18, DoEor, DB, SdB, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Opbf20, DoEor, DB, SdB, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Opbf28, DoEor, DB, SdB, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Opbf30, DoEor, DB, SdB, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Opbf38, DoEor, DB, SdB, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Opbf40, DoEor, DW, SdW, 7, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Opbf50, DoEor, DW, SdW, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Opbf58, DoEor, DW, SdW, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Opbf60, DoEor, DW, SdW, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Opbf68, DoEor, DW, SdW, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Opbf70, DoEor, DW, SdW, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Opbf78, DoEor, DW, SdW, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Opbf80, DoEor, DL, SdL, 7, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Opbf90, DoEor, DL, SdL, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Opbf98, DoEor, DL, SdL, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Opbfa0, DoEor, DL, SdL, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Opbfa8, DoEor, DL, SdL, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Opbfb0, DoEor, DL, SdL, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Opbfb8, DoEor, DL, SdL, 7, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op0000, DoOr, DB, SimmB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op0010, DoOr, DB, SimmB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op0018, DoOr, DB, SimmB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op0020, DoOr, DB, SimmB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op0028, DoOr, DB, SimmB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op0030, DoOr, DB, SimmB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
OlogSR (Op0038, DoOr, DoOrSR, 0, DB, SimmB, DB, GMB, SMB, GCB, SCB)
Oper (Op0040, DoOr, DW, SimmW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op0050, DoOr, DW, SimmW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op0058, DoOr, DW, SimmW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op0060, DoOr, DW, SimmW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op0068, DoOr, DW, SimmW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op0070, DoOr, DW, SimmW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
OlogSR (Op0078, DoOr, DoOrSR, 1, DW, SimmW, DW, GMW, SMW, GCW, SCW)
Oper (Op0080, DoOr, DL, SimmL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op0090, DoOr, DL, SimmL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op0098, DoOr, DL, SimmL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op00a0, DoOr, DL, SimmL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op00a8, DoOr, DL, SimmL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op00b0, DoOr, DL, SimmL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op00b8, DoOr, DL, SimmL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op0200, DoAnd, DB, SimmB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op0210, DoAnd, DB, SimmB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op0218, DoAnd, DB, SimmB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op0220, DoAnd, DB, SimmB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op0228, DoAnd, DB, SimmB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op0230, DoAnd, DB, SimmB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
OlogSR (Op0238, DoAnd, DoAndSR, 0, DB, SimmB, DB, GMB, SMB, GCB, SCB)
Oper (Op0240, DoAnd, DW, SimmW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op0250, DoAnd, DW, SimmW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op0258, DoAnd, DW, SimmW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op0260, DoAnd, DW, SimmW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op0268, DoAnd, DW, SimmW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op0270, DoAnd, DW, SimmW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
OlogSR (Op0278, DoAnd, DoAndSR, 1, DW, SimmW, DW, GMW, SMW, GCW, SCW)
Oper (Op0280, DoAnd, DL, SimmL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op0290, DoAnd, DL, SimmL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op0298, DoAnd, DL, SimmL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op02a0, DoAnd, DL, SimmL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op02a8, DoAnd, DL, SimmL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op02b0, DoAnd, DL, SimmL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op02b8, DoAnd, DL, SimmL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op0a00, DoEor, DB, SimmB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op0a10, DoEor, DB, SimmB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op0a18, DoEor, DB, SimmB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op0a20, DoEor, DB, SimmB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op0a28, DoEor, DB, SimmB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op0a30, DoEor, DB, SimmB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
OlogSR (Op0a38, DoEor, DoEorSR, 0, DB, SimmB, DB, GMB, SMB, GCB, SCB)
Oper (Op0a40, DoEor, DW, SimmW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op0a50, DoEor, DW, SimmW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op0a58, DoEor, DW, SimmW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op0a60, DoEor, DW, SimmW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op0a68, DoEor, DW, SimmW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op0a70, DoEor, DW, SimmW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
OlogSR (Op0a78, DoEor, DoEorSR, 1, DW, SimmW, DW, GMW, SMW, GCW, SCW)
Oper (Op0a80, DoEor, DL, SimmL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op0a90, DoEor, DL, SimmL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op0a98, DoEor, DL, SimmL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op0aa0, DoEor, DL, SimmL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op0aa8, DoEor, DL, SimmL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op0ab0, DoEor, DL, SimmL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op0ab8, DoEor, DL, SimmL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)
